/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml.core.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.build.IProblem;
import com.aptana.parsing.AbstractParser;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.parsing.ast.ParseNodeAttribute;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.aptana.xml.core.parsing.XMLScanner;
import com.aptana.xml.core.parsing.ast.XMLCDATANode;
import com.aptana.xml.core.parsing.ast.XMLCommentNode;
import com.aptana.xml.core.parsing.ast.XMLElementNode;
import com.aptana.xml.core.parsing.ast.XMLNode;
import com.aptana.xml.core.parsing.ast.XMLNodeType;
import com.aptana.xml.core.parsing.ast.XMLParseRootNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser
extends AbstractParser {
    public static final XMLNode[] NO_XML_NODES = new XMLNode[0];
    private Stack<IParseNode> fElementStack;
    private IProgressMonitor fMonitor;
    private XMLScanner fScanner;
    protected IParseNode fCurrentElement;
    private List<IParseNode> fCommentNodes = new ArrayList<IParseNode>();
    protected Symbol fCurrentLexeme;
    private WorkingParseResult fWorking;

    public XMLParser() {
        this.fScanner = new XMLScanner();
    }

    protected void closeElement() {
        this.fCurrentElement = this.fElementStack.size() > 0 ? this.fElementStack.pop() : null;
    }

    protected void openElement(XMLElementNode element) {
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)element);
        }
        this.fElementStack.push(this.fCurrentElement);
        this.fCurrentElement = element;
    }

    protected void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fMonitor = parseState.getProgressMonitor();
        this.fWorking = working;
        this.fElementStack = new Stack();
        String source = parseState.getSource();
        this.fScanner.setSource(source);
        int startingOffset = parseState.getStartingOffset();
        XMLParseRootNode root = new XMLParseRootNode(startingOffset, startingOffset + source.length() - 1);
        try {
            this.fCurrentElement = root;
            this.parseAll((IParseNode)root);
            root.setCommentNodes(this.fCommentNodes.toArray(new IParseNode[this.fCommentNodes.size()]));
            working.setParseResult((IParseRootNode)root);
        }
        finally {
            this.fMonitor = null;
            this.fWorking = null;
            this.fElementStack = null;
            this.fCurrentElement = null;
            this.fCommentNodes.clear();
        }
    }

    protected void parseAll(IParseNode root) throws IOException, Exception {
        this.advance();
        while (this.fCurrentLexeme.getId() != 0 && !this.fMonitor.isCanceled()) {
            this.processStatement();
            this.advance();
        }
    }

    protected void advance() throws Scanner.Exception, IOException {
        this.fCurrentLexeme = this.fScanner.nextToken();
    }

    protected List<IParseNodeAttribute> parseAttributes() throws Scanner.Exception, IOException {
        ArrayList<IParseNodeAttribute> result = new ArrayList<IParseNodeAttribute>();
        XMLNode fakeParent = new XMLNode(XMLNodeType.ELEMENT, 0, 0);
        Symbol nameSymbol = null;
        boolean nextIsValue = false;
        try {
            block8: while (true) {
                this.advance();
                switch (this.fCurrentLexeme.getId()) {
                    case 0: 
                    case 5: 
                    case 8: {
                        Range nameRegion;
                        String name;
                        if (nameSymbol != null) {
                            this.fWorking.addError((IParseError)new ParseError("org.eclipse.core.runtime.xml", nameSymbol, "Attribute declared with no value", IProblem.Severity.ERROR));
                            name = (String)nameSymbol.value;
                            nameRegion = new Range(nameSymbol.getStart(), nameSymbol.getEnd());
                            result.add((IParseNodeAttribute)new ParseNodeAttribute((IParseNode)fakeParent, name, name, (IRange)nameRegion, null));
                            nextIsValue = false;
                            nameSymbol = null;
                        }
                        return result;
                    }
                    case 10: {
                        nextIsValue = true;
                        continue block8;
                    }
                    case 4: 
                    case 6: {
                        Range nameRegion;
                        String name;
                        if (nameSymbol == null) {
                            nameSymbol = this.fCurrentLexeme;
                            continue block8;
                        }
                        if (nextIsValue) {
                            this.fWorking.addError((IParseError)new ParseError("org.eclipse.core.runtime.xml", this.fCurrentLexeme, "Unquoted attribute value", IProblem.Severity.ERROR));
                            name = (String)nameSymbol.value;
                            nameRegion = new Range(nameSymbol.getStart(), nameSymbol.getEnd());
                            result.add((IParseNodeAttribute)new ParseNodeAttribute((IParseNode)fakeParent, name, (String)this.fCurrentLexeme.value, (IRange)nameRegion, (IRange)new Range(this.fCurrentLexeme.getStart(), this.fCurrentLexeme.getEnd())));
                            nextIsValue = false;
                            nameSymbol = null;
                            continue block8;
                        }
                        this.fWorking.addError((IParseError)new ParseError("org.eclipse.core.runtime.xml", nameSymbol, "Attribute declared with no value", IProblem.Severity.ERROR));
                        name = (String)nameSymbol.value;
                        nameRegion = new Range(nameSymbol.getStart(), nameSymbol.getEnd());
                        result.add((IParseNodeAttribute)new ParseNodeAttribute((IParseNode)fakeParent, name, name, (IRange)nameRegion, null));
                        nameSymbol = this.fCurrentLexeme;
                        continue block8;
                    }
                    case 11: {
                        String name = (String)nameSymbol.value;
                        Range nameRegion = new Range(nameSymbol.getStart(), nameSymbol.getEnd());
                        result.add((IParseNodeAttribute)new ParseNodeAttribute((IParseNode)fakeParent, name, (String)this.fCurrentLexeme.value, (IRange)nameRegion, (IRange)new Range(this.fCurrentLexeme.getStart(), this.fCurrentLexeme.getEnd())));
                        nextIsValue = false;
                        nameSymbol = null;
                        continue block8;
                    }
                }
            }
        }
        catch (Throwable t) {
            this.fWorking.addError((IParseError)new ParseError("org.eclipse.core.runtime.xml", this.fCurrentLexeme.getStart(), this.fCurrentLexeme.getEnd() - this.fCurrentLexeme.getStart(), "Invalid attribute value", IProblem.Severity.ERROR));
            return result;
        }
    }

    protected void processComment() {
        XMLCommentNode comment = new XMLCommentNode((String)this.fCurrentLexeme.value, this.fCurrentLexeme.getStart(), this.fCurrentLexeme.getEnd());
        this.fCommentNodes.add((IParseNode)comment);
        if (this.fCurrentElement != null) {
            this.fCurrentElement.addChild((IParseNode)comment);
        }
    }

    protected void processCDATA() {
        if (this.fCurrentElement != null) {
            XMLCDATANode comment = new XMLCDATANode((String)this.fCurrentLexeme.value, this.fCurrentLexeme.getStart(), this.fCurrentLexeme.getEnd());
            this.fCurrentElement.addChild((IParseNode)comment);
        }
    }

    protected void processEndTag() throws Scanner.Exception, IOException {
        this.advance();
        this.advance();
        ((ParseNode)this.fCurrentElement).setLocation(this.fCurrentElement.getStartingOffset(), this.fCurrentLexeme.getEnd());
        this.closeElement();
    }

    protected void processStartTag() throws Scanner.Exception, IOException {
        int start = this.fCurrentLexeme.getStart();
        this.advance();
        Symbol tag = this.fCurrentLexeme;
        List<IParseNodeAttribute> attrs = this.parseAttributes();
        XMLElementNode element = new XMLElementNode(tag, start, this.fCurrentLexeme);
        for (IParseNodeAttribute attr : attrs) {
            element.setAttribute(attr.getName(), attr.getValue(), attr.getNameRange(), attr.getValueRange());
        }
        this.openElement(element);
        if (element.isSelfClosing()) {
            this.closeElement();
        }
    }

    protected void processStatement() throws Scanner.Exception, IOException {
        switch (this.fCurrentLexeme.getId()) {
            case 3: {
                this.processComment();
                break;
            }
            case 6: 
            case 7: {
                this.processCDATA();
                break;
            }
            case 1: {
                this.processStartTag();
                break;
            }
            case 9: {
                this.processEndTag();
            }
        }
    }
}

